#%%
import numpy as np
import matplotlib.pyplot as plt

#%%
t=8*np.arange(11)
Xmes=np.array([-0.2,2.9,5.4,6.4,5,1.2,-3.4,-6.4,-6.9,-5.7,-3.3])
Ymes=np.array([-8.2,-7.3,-4.9,-1.2,2.9,5.3,4.7,1.5,-2.3,-5.5,-7.5])
x=Xmes*0.46/8.2
y=Ymes*0.46/8.2

vxl=[]
m=np.arange(len(t)-2)
for i in m :
    vx=(x[i+2]-x[i])/(t[i+2]-t[i])
    vxl.append(vx)

vyl=[]
m=np.arange(len(t)-2)
for i in m :
    vy=(y[i+2]-y[i])/(t[i+2]-t[i])
    vyl.append(vy)

axl=[]
m=np.arange(len(t)-4)
for i in m :
    ax=(vxl[i+2]-vxl[i])/(t[i+2]-t[i])
    axl.append(ax)
ayl=[]
m=np.arange(len(t)-4)
for i in m :
    ay=(vyl[i+2]-vyl[i])/(t[i+2]-t[i])
    ayl.append(ay)
#%%
# Courbe
plt.figure()
for i in m :
    plt.arrow(x[i+2],y[i+2],200*axl[i],200*ayl[i],head_width=0.02)
plt.xlim(-15,15)
plt.ylim(-15,15)
plt.axis('equal')
plt.grid()
plt.plot(x,y,'bo')
plt.show()
#%%

ayln=1.5*10**11*np.array(ayl)/(24*3600)**2
axln=1.5*10**11*np.array(axl)/(24*3600)**2
norma=(ayln**2+axln**2)**(1/2)
dx=x[:-2]*1.5*10**11
dy=y[:-2]*1.5*10**11
d=(dx**2+dy**2)**(1/2)

dr=d[2:]
GM=dr**2*norma
GMth=6.67*10**(-11)*2*10**30
n=np.arange(len(t)-4)
#%%
# Courbe
plt.figure()
plt.plot(n,GM*10**(-20),'bo',label="points expérimentaux")
plt.legend()
plt.grid()


mod=np.polyfit(n,GM,0)
M=float(mod[0]/(6.67*10**(-11)))
print('la masse du soleil est de l ordre de',"%.1e"%M,'kg')
GMmod=0*n+mod[0]



plt.plot(n,(GMmod)*10**(-20),'r-',label="modèle")
plt.legend()
plt.ylim(0,5)
plt.xlabel("point de mesure")
plt.ylabel("valeur du produit GMs x10^20")
plt.show()

#%%
plt.figure()
drci=1/(dr)**2
plt.plot(drci,norma,'bo',label="points expérimentaux")
plt.legend()
plt.grid()
model=6.67*10**(-11)*1.7*10**30*drci
plt.plot(drci,model,'r-',label="modèle")
plt.legend()
plt.xlabel("1/d^2")
plt.ylabel("accélération")
plt.show()
